#!/usr/bin/env python3

"""Config system (based on Detectron's)."""

from ..bin.config_node import CfgNode


# Global config object
_C = CfgNode()
_C.exp_group = ""
_C.local_rank = -1
_C.action = ""
_C.device = ""
_C.seed = 42
_C.wandb = False
_C.ddp = False

_C.Data = CfgNode()
_C.Data.Name = "Cifar10"
_C.Data.path = ""
_C.Data.balanced = True
_C.Data.amount_per_class = 50 # if balanced == Flase, amount_per_class is nonactivated

_C.Classifier = CfgNode()
_C.Classifier.Name = "ConvNet"
_C.Classifier.path = ""
_C.Classifier.load_path = ""
_C.Classifier.batch_size = 0
_C.Classifier.lr = 1e-3
_C.Classifier.weight_decay = 1e-4
_C.Classifier.epoches = 1000
_C.Classifier.num_classes = 0
_C.Classifier.normalization = True
_C.Classifier.input_shape = [128]
_C.Classifier.hidden_dims = [512]
_C.Classifier.pretrain = True
_C.Classifier.output_feature = False
_C.Classifier.evaluation_interval = 5
_C.Classifier.save_interval = 500
_C.Classifier.activation_name = "ModifiedRelu"

_C.Generator = CfgNode()
_C.Generator.Name = "DCG"
_C.Generator.path = ""
_C.Generator.batch_size = 128
_C.Generator.lr = 1e-3
_C.Generator.weight_decay = 1e-4
_C.Generator.epoches = 1000
_C.Generator.evaluation_interval = 20
_C.Generator.image_save_interval = 500
_C.Generator.num_latent_feature = 128
_C.Generator.num_class_embedding = 128
_C.Generator.hidden_dims = [512,512]
_C.Generator.tanh = False
_C.Generator.num_samples = 50
_C.Generator.noise_channel = 128
_C.Generator.embedding_channel = 16
_C.Generator.duality_threshold = 1.0
_C.Generator.lagrange_coe = 1.0
_C.Generator.duality_coe = 1.0
_C.Generator.regularization_coe = 1.0
_C.Generator.normalization_match_coe = 0.0
_C.Generator.regulariztion_name = "tv"
_C.Generator.tv_power = 2.0
_C.Generator.noise_scale = 0.5
_C.Generator.noise_clamp = 0.5
_C.Generator.delta = 0.5
_C.Generator.first_class_probability = 0.8
_C.Generator.fixed_label = True
_C.Generator.fixed_noise = False
_C.Generator.double_label = False
_C.Generator.use_stationarity_loss = True
_C.Generator.use_kl_loss = True
_C.Generator.first_class_probability_use_alpha = False
_C.Generator.save_along = False
_C.Generator.use_second_order_stationarity = True

_C.Lambda = CfgNode()
_C.Lambda.use = False
_C.Lambda.path = ""
_C.Lambda.num_samples = 50

_C.muer = CfgNode()
_C.muer.use = False
_C.muer.Name = "linear_xy"
_C.muer.path = ""
_C.muer.lr = 1e-3
_C.muer.weight_decay = 1e-4
_C.muer.num_class_embedding = 128

_C.alpha = CfgNode()
_C.alpha.use = False
_C.alpha.path = ""
_C.alpha.lr = 1e-3
_C.alpha.weight_decay = 0.0

_C.pathes = CfgNode()
_C.pathes.trash_path = ""
_C.pathes.log_path = ""
_C.pathes.img_path = ""
_C.pathes.model_path = ""



def get_cfg():
    """
    Get a copy of the default config.
    """
    return _C.clone()
